<?php

namespace App\Livewire;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Livewire\Component;

class AfterAuth extends Component
{
    public function mount()
    {
        $user = Auth::user();
        if ($user->can('access admin panel')) {
            $this->redirectRoute('filament.admin.pages.dashboard');
        } else {
            $billingProvider = $user->billing_provider;
            $sessionKey = Session::has('subscribeToPlan') ? 'subscribeToPlan' : null;
            if ($sessionKey) {
                $plan = Session::get($sessionKey);
                if ($billingProvider === 'stripe') {
                    Session::forget($sessionKey);
                    $this->redirectRoute('checkoutStripe', ['stripePriceId' => $plan]);
                }
            } else {
                $this->redirectRoute('dashboard');
            }
        }
    }
}
