<?php

namespace App\Livewire\Page\Home;

use App\Models\SubscriptionPlan;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Livewire\Attributes\Layout;
use Livewire\Attributes\Locked;
use Livewire\Attributes\Renderless;
use Livewire\Attributes\Title;
use Livewire\Component;

#[Title('SaaShovel')]
class Home extends Component
{
    #[Locked]
    public $plans;
    #[Locked]
    public $billingProvider;

    #[Renderless]
    public function subscribeToPlan($plan)
    {
        Session::put('billing_provider', $this->billingProvider);
        Session::put('subscribeToPlan', $plan);
        $this->redirectRoute('register');
    }

    public function mount()
    {
        if (Session::has('subscribeToPlan')) {
            Session::forget(['subscribeToPlan', 'billing_provider']);
        }

        $this->billingProvider = Auth::user()?->billing_provider ?? config('saashovel.BILLING_PROVIDER');
        $this->plans = SubscriptionPlan::where('billing_provider', $this->billingProvider)->get()->keyBy('tier')->toArray();
    }

    #[Layout('layouts.guest')]
    public function render()
    {
         return view(Auth::check() && Auth::user()->can('access premium features') ? 'livewire.pages.home.home' : 'livewire.pages.landing-page.landing-page');
    }
}
