<div>
    <!-- Landing Page Content (for guests) -->
    <div class="bg-white overflow-hidden shadow-xl sm:rounded-lg p-6 mt-6">
        <h1 class="text-2xl font-semibold text-gray-800">Welcome to the Landing Page!</h1>
        <p class="mt-4 text-gray-600">
            This is the landing page visible to guests. You can customize this page by editing the Blade view at:
            <code class="text-sm bg-gray-100 px-1 rounded">resources\views\livewire\pages\landing-page\landing-page.blade.php</code>. <br>
            There are already some example components you can experiment with by uncommenting them to see how they work. If you want more details, you can <a href="https://saashovel.com/documentation#Components" class="text-blue-500 hover:underline">refer to the documentation</a>.
        </p>
        <p class="mt-2 text-gray-600">
            Component logic is shared with the Home page in:
            <code class="text-sm bg-gray-100 px-1 rounded">app\Livewire\Page\Home\Home.php</code>. The component checks if a user is logged in and loads the appropriate view.
        </p>
    </div>
    <x-hero-section
        title="Build Your SaaS With A Solid Foundation!"
        subtitle='A Laravel/Livewire starter-kit for your SaaS with Stripe support, CMS, auth, permissions, localization, and more. Save hours of work and focus on shipping your best ideas!'
        ctaText="Start Building Now"
        ctaUrl="#pricing"
    >
        <x-slot name="svg">
            <svg class="block h-48 sm:h-64 md:h-80 lg:h-96 w-auto m-auto text-lime-600" version="1.0" xmlns="http://www.w3.org/2000/svg" width="451.000000pt" height="378.000000pt" viewBox="0 0 451.000000 378.000000" preserveAspectRatio="xMidYMid meet">
                <g transform="translate(0.000000,378.000000) scale(0.100000,-0.100000)" fill="currentColor" stroke="none">
                    <path d="M2448 3700 c-190 -27 -346 -74 -525 -160 -472 -225 -867 -653 -1033
                    -1117 -18 -51 -38 -93 -44 -93 -20 1 -93 37 -147 74 -30 20 -55 32 -57 26 -5
                    -15 35 -135 73 -217 51 -111 117 -206 213 -305 70 -73 196 -178 213 -178 2 0
                    3 60 1 134 -8 317 106 607 362 920 271 332 700 584 1079 635 238 32 468 -11
                    627 -119 112 -76 226 -224 264 -344 14 -41 14 -7 1 69 -25 144 -92 294 -172
                    391 -99 118 -285 228 -448 264 -105 23 -309 33 -407 20z"/>
                    <path d="M2480 3231 c-317 -70 -582 -231 -823 -500 -157 -176 -270 -392 -318
                    -606 -17 -76 -17 -286 0 -345 32 -117 40 -128 98 -150 30 -11 73 -25 96 -30
                    67 -15 251 -12 321 6 71 18 190 72 226 101 l24 20 -68 304 c-66 291 -68 308
                    -63 399 12 202 102 352 281 468 79 52 191 101 286 127 86 23 298 31 398 15 83
                    -13 227 -60 281 -91 18 -11 35 -18 37 -16 9 8 -62 104 -112 152 -62 60 -147
                    108 -242 137 -99 30 -308 34 -422 9z"/>
                    <path d="M2870 2783 c-56 -10 -168 -47 -220 -73 -98 -49 -96 -26 -23 -345 90
                    -391 90 -488 -4 -667 -96 -184 -347 -332 -626 -369 -149 -21 -366 14 -511 81
                    -37 18 -70 29 -73 27 -9 -10 53 -91 114 -148 174 -166 457 -209 767 -117 680
                    200 1193 951 1015 1487 -19 57 -25 65 -63 81 -89 39 -275 60 -376 43z"/>
                    <path d="M3525 2497 c0 -113 -5 -173 -19 -232 -82 -354 -298 -680 -631 -951
                    -176 -143 -425 -270 -644 -326 -149 -38 -361 -49 -487 -25 -255 48 -458 210
                    -540 429 -28 77 -32 46 -8 -70 51 -248 187 -434 404 -551 335 -180 840 -124
                    1294 143 265 156 508 385 681 643 76 112 174 306 205 403 12 41 26 79 30 83
                    10 12 68 -14 150 -67 40 -26 70 -40 70 -33 0 29 -61 191 -101 268 -88 169
                    -231 328 -379 422 l-25 16 0 -152z"/>
                    <path d="M720 1540 c-29 -31 -40 -67 -40 -134 0 -44 -22 -86 -45 -86 -39 0
                    -62 83 -30 110 22 18 19 33 -15 65 -26 25 -31 26 -46 14 -9 -8 -23 -28 -31
                    -46 -43 -104 35 -243 136 -243 72 0 107 48 119 163 7 68 8 72 32 72 23 0 25
                    -4 26 -42 0 -30 9 -51 31 -79 l30 -38 17 32 c9 17 16 53 16 79 0 126 -127 211
                    -200 133z"/>
                    <path d="M3967 1493 c-2 -4 -12 -34 -21 -65 -9 -31 -21 -60 -26 -63 -5 -3 -76
                    15 -156 40 -81 26 -150 43 -154 38 -4 -4 -13 -24 -19 -43 -11 -33 -10 -37 15
                    -58 14 -13 33 -21 41 -17 9 3 81 -15 160 -40 80 -25 149 -45 154 -45 13 0 83
                    230 73 240 -14 13 -61 23 -67 13z"/>
                    <path d="M3513 1219 c-6 -8 -38 -55 -71 -105 l-60 -92 21 -31 c13 -18 28 -29
                    36 -26 8 3 72 -33 143 -80 70 -47 131 -85 136 -85 4 0 37 46 75 103 l67 102
                    -28 22 c-15 13 -30 23 -33 23 -4 0 -24 -27 -45 -60 -21 -33 -43 -60 -50 -60
                    -6 0 -22 9 -35 19 l-24 20 23 41 c13 23 22 43 20 44 -2 1 -16 10 -32 20 -32
                    20 -30 22 -70 -39 -12 -18 -15 -19 -41 -5 -35 19 -42 37 -25 64 52 83 51 79
                    27 110 -19 23 -25 26 -34 15z"/>
                    <path d="M1010 1123 c-8 -3 -19 -12 -23 -19 -4 -7 -74 -34 -155 -60 -81 -26
                    -151 -51 -156 -55 -5 -5 1 -23 15 -44 22 -33 27 -35 64 -29 36 5 42 2 61 -23
                    42 -57 45 -69 27 -101 -16 -28 -16 -30 6 -65 12 -21 26 -37 31 -37 4 0 16 12
                    25 28 17 25 47 67 173 237 29 39 52 73 52 76 0 3 -16 27 -35 53 -34 44 -51 52
                    -85 39z m-62 -188 c-27 -41 -44 -44 -60 -10 -14 30 -6 40 42 53 44 11 48 1 18
                    -43z"/>
                    <path d="M3247 871 l-35 -31 38 -98 c52 -134 54 -142 38 -142 -7 0 -55 30
                    -107 65 -52 36 -100 65 -105 65 -6 0 -26 -13 -45 -29 -33 -27 -34 -30 -22 -60
                    15 -35 15 -35 40 -21 14 7 47 -10 161 -86 134 -89 144 -94 164 -80 44 32 56
                    44 56 57 0 19 -128 371 -139 382 -5 5 -24 -5 -44 -22z"/>
                    <path d="M1345 762 c-12 -9 -24 -25 -27 -34 -4 -9 -62 -58 -130 -109 -68 -51
                    -125 -94 -127 -96 -7 -5 41 -52 61 -59 11 -3 29 3 44 15 l26 20 49 -32 c49
                    -32 50 -33 44 -73 -6 -40 -4 -43 30 -64 20 -12 38 -20 41 -17 11 11 123 390
                    118 398 -7 12 -91 69 -101 69 -4 -1 -17 -8 -28 -18z m1 -177 c-3 -13 -11 -36
                    -16 -51 -10 -25 -12 -25 -33 -11 -32 21 -31 39 5 65 42 28 52 28 44 -3z"/>
                    <path d="M2701 558 c-25 -13 -59 -40 -75 -61 -27 -34 -31 -47 -31 -101 0 -82
                    41 -167 103 -210 74 -53 182 -34 240 42 20 27 27 49 30 99 4 56 1 71 -28 129
                    -54 110 -148 150 -239 102z m113 -102 c55 -57 71 -144 35 -190 -37 -47 -95
                    -23 -128 53 -28 65 -27 118 1 148 30 32 55 29 92 -11z"/>
                    <path d="M1703 556 c-41 -19 -67 -68 -59 -111 6 -30 17 -44 117 -137 29 -27
                    23 -58 -14 -71 -28 -11 -67 13 -75 47 -7 28 -13 31 -51 34 -57 4 -66 -6 -46
                    -54 21 -51 42 -73 90 -95 111 -51 224 6 213 106 -6 50 -26 79 -85 125 -31 23
                    -43 39 -41 54 4 31 36 31 67 2 24 -23 33 -26 69 -20 46 7 49 12 27 54 -32 61
                    -144 97 -212 66z"/>
                    <path d="M2100 461 c-13 -25 -13 -54 0 -67 5 -5 11 -79 12 -164 l3 -155 47 -3
                    47 -3 3 83 3 83 52 3 52 3 3 -83 3 -83 44 -3 c24 -2 48 1 53 6 6 6 7 85 2 206
                    l-7 196 -48 0 -49 0 0 -80 0 -80 -55 0 -55 0 0 80 0 80 -50 0 c-38 0 -52 -4
                    -60 -19z"/>
                </g>
            </svg>
        </x-slot>
        <x-slot name="tagline">
            <p class="mb-4 lg:mb-0 text-center mt-2 text-lime-600 text-base sm:text-lg md:text-xl lg:text-2xl ml-6 font-bold">Stop digging <img src="{{ asset('logos/shovel.png') }}" alt="Shovel" class="inline h-7">, start building! <img src="{{ asset('logos/building.png') }}" alt="Building" class="inline h-7"> </p>
        </x-slot>
    </x-hero-section>

    {{-- <x-features-grid title="Skip the foundation, start building your SaaS today">
        <x-feature-item
            icon='<rect x="2" y="3" width="20" height="14" rx="2" ry="2" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"></rect><line x1="2" y1="20" x2="22" y2="20" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"></line><line x1="6" y1="7" x2="18" y2="7" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"></line><line x1="6" y1="11" x2="14" y2="11" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"></line><line x1="6" y1="15" x2="10" y2="15" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"></line>'
            title="Built-in CMS"
        >
            <p>Create and manage content with ease. Set page permissions to restrict access to subscribers of specific tiers. Includes customizable contact page for customer interaction and a flexible FAQ section.</p>
        </x-feature-item>

        <x-feature-item
            icon='<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path>'
            title="TALL Stack Powered"
        >
            <p>
                Leverage the power of
                <a href="https://tailwindcss.com" target="_blank" rel="noopener noreferrer" class="font-bold text-lime-600 hover:underline">Tailwind</a>,
                <a href="https://alpinejs.dev" target="_blank" rel="noopener noreferrer" class="font-bold text-lime-600 hover:underline">Alpine.js</a>,
                <a href="https://laravel.com" target="_blank" rel="noopener noreferrer" class="font-bold text-lime-600 hover:underline">Laravel</a>, and
                <a href="https://livewire.laravel.com" target="_blank" rel="noopener noreferrer" class="font-bold text-lime-600 hover:underline">Livewire</a>
                for a modern, reactive, and scalable application. As well as <a href="https://jetstream.laravel.com" target="_blank" rel="noopener noreferrer" class="font-bold text-lime-600 hover:underline">Jetstream</a> for user's account management and <a href="https://filamentphp.com" target="_blank" rel="noopener noreferrer" class="font-bold text-lime-600 hover:underline">Filament</a> for the admin panel.
            </p>
        </x-feature-item>

        <x-feature-item
            icon='<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5h12M9 3v2m1.048 9.5A18.022 18.022 0 016.412 9m6.088 9h7M11 21l5-10 5 10M12.751 5C11.783 10.77 8.07 15.61 3 18.129"></path>'
            title="Built-in Localization"
        >
            <p>Reach a global audience with out-of-the-box localization support. Easily translate your SaaS into multiple languages.</p>
        </x-feature-item>

        <x-feature-item
            icon='<circle cx="12" cy="12" r="10" /><circle cx="8" cy="9" r="1" /><circle cx="15" cy="9" r="1" /><circle cx="9" cy="15" r="1" /><circle cx="14" cy="14" r="1" /><path d="M21.17 8C18.37 4.61 14.4 2.61 10 2.61" />'
            title="Cookie Consent"
        >
            <p>Easily comply with privacy regulations by implementing a customizable cookie consent banner, giving users control over their data.</p>
        </x-feature-item>

        <x-feature-item
            icon='<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 3v6a1 1 0 001 1h6"/>'
            title="Terms and Privacy Policy"
        >
            <p>Protect your business with pre-built, customizable terms of service and privacy policy pages (as well as the relevant checkbox on the registration form), ensuring legal compliance from day one.</p>
        </x-feature-item>
    </x-features-grid> --}}

    <x-interactive-features-section
        id="features"
        title="Unleash the potential of your SaaS"
        description="Don't let technical debt bury your SaaS before it begins. SaaShovel provides the robust foundation you need - from user logins to payment processing. Construct your dream SaaS on solid ground and reach profitability faster."
    >
        <x-interactive-feature-tab
            tabId="subscription"
            name="Subscriptions"
            mediaType="video"
            mediaUrl="{{ asset('illustrations/subscription.mp4') }}"
            icon='
            <svg xmlns="http://www.w3.org/2000/svg" class="w-8 h-8 mb-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 5v2m0 4v2m0 4v2M5 5a2 2 0 00-2 2v3a2 2 0 110 4v3a2 2 0 002 2h14a2 2 0 002-2v-3a2 2 0 110-4V7a2 2 0 00-2-2H5z"/>
            </svg>
            '
            title="Effortless Subscription Journey"
            description="Experience a smooth, end-to-end subscription process:"
            :features="[
                'One-click plan selection',
                'Streamlined user registration',
                'User dashboard to manage subscription',
                'Webhook handling',
            ]"
        >
        </x-interactive-feature-tab>

        <x-interactive-feature-tab
            tabId="permissions"
            name="Permissions"
            mediaType="image"
            mediaUrl="{{ asset('illustrations/permissions.png') }}"
            icon='
            <svg xmlns="http://www.w3.org/2000/svg" class="w-8 h-8 mb-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"/>
            </svg>
            '
            title="Smooth Permission Handling"
            description="Effortlessly manage user access with the powerful and flexible permission system:"
            :features="[
                '<b>@can</b> and <b>@cannot</b> directives to restrict access',
                '<b>$user->can()</b> and <b>$user->cannot()</b> methods for granular control',
                'Route <b>middlewares</b> to restrict access to specific subscriber tiers'
            ]"
        >
        </x-interactive-feature-tab>

        <x-interactive-feature-tab
            tabId="auth"
            name="Auth"
            mediaType="video"
            mediaUrl="{{ asset('illustrations/auth.mp4') }}"
            icon='
            <svg xmlns="http://www.w3.org/2000/svg" class="w-8 h-8 mb-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 11c0 3.517-1.009 6.799-2.753 9.571m-3.44-2.04l.054-.09A13.916 13.916 0 008 11a4 4 0 118 0c0 1.017-.07 2.019-.203 3m-2.118 6.844A21.88 21.88 0 0015.171 17m3.839 1.132c.645-2.266.99-4.659.99-7.132A8 8 0 008 4.07M3 15.364c.64-1.319 1-2.8 1-4.364 0-1.457.39-2.823 1.07-4"/>
            </svg>
            '
            title="Modern Authentication"
            description="Leverage secure and user-friendly authentication features:"
            :features="[
                'Social login integration',
                'Two-factor authentication',
                'Email confirmation functionality',
                'Password reset functionality',
                'Customizable design',
                'Laravel Jetstream with teams integration',
            ]"
        >
        </x-interactive-feature-tab>

        <x-interactive-feature-tab
            tabId="cms"
            name="CMS"
            mediaType="video"
            mediaUrl="{{ asset('illustrations/cms.mp4') }}"
            icon='
            <svg xmlns="http://www.w3.org/2000/svg" class="w-8 h-8 mb-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
            </svg>
            '
            title="Built-in CMS"
            description="Create and manage content with ease:"
            :features="[
                'Set page permissions to restrict access to subscribers of specific tiers',
                'Customizable contact page for customer interaction',
                'Flexible FAQ section',
                'Easy content creation and management',
                'SEO optimization tools',
            ]"
        >
        </x-interactive-feature-tab>

        <x-interactive-feature-tab
            tabId="admin"
            name="Admin"
            mediaType="video"
            mediaUrl="{{ asset('illustrations/admin.mp4') }}"
            icon='
            <svg xmlns="http://www.w3.org/2000/svg" class="w-8 h-8 mb-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.594 3.94c.09-.542.56-.94 1.11-.94h2.593c.55 0 1.02.398 1.11.94l.213 1.281c.063.374.313.686.645.87.074.04.147.083.22.127.325.196.72.257 1.075.124l1.217-.456a1.125 1.125 0 0 1 1.37.49l1.296 2.247a1.125 1.125 0 0 1-.26 1.431l-1.003.827c-.293.241-.438.613-.43.992a7.723 7.723 0 0 1 0 .255c-.008.378.137.75.43.991l1.004.827c.424.35.534.955.26 1.43l-1.298 2.247a1.125 1.125 0 0 1-1.369.491l-1.217-.456c-.355-.133-.75-.072-1.076.124a6.47 6.47 0 0 1-.22.128c-.331.183-.581.495-.644.869l-.213 1.281c-.09.543-.56.94-1.11.94h-2.594c-.55 0-1.019-.398-1.11-.94l-.213-1.281c-.062-.374-.312-.686-.644-.87a6.52 6.52 0 0 1-.22-.127c-.325-.196-.72-.257-1.076-.124l-1.217.456a1.125 1.125 0 0 1-1.369-.49l-1.297-2.247a1.125 1.125 0 0 1 .26-1.431l1.004-.827c.292-.24.437-.613.43-.991a6.932 6.932 0 0 1 0-.255c.007-.38-.138-.751-.43-.992l-1.004-.827a1.125 1.125 0 0 1-.26-1.43l1.297-2.247a1.125 1.125 0 0 1 1.37-.491l1.216.456c.356.133.751.072 1.076-.124.072-.044.146-.086.22-.128.332-.183.582-.495.644-.869l.214-1.28Z" />
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 1 1-6 0 3 3 0 0 1 6 0Z" />
            </svg>
            '
            title="Comprehensive Admin Panel"
            description="Manage your SaaS efficiently with a feature-rich admin panel powered by Filament:"
            :features="[
                'Google Analytics integration',
                'User management with impersonation support',
                'Customizable dashboard',
                '.Env config to customize features',
                'Contact feature management',
                'CMS features control'
            ]"
        >
        </x-interactive-feature-tab>

        <x-interactive-feature-tab
            tabId="components"
            name="Components"
            mediaType="image"
            mediaUrl="{{ asset('illustrations/component.png') }}"
            icon='
            <svg xmlns="http://www.w3.org/2000/svg" class="w-8 h-8 mb-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2V6zM14 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2V6zM4 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2v-2zM14 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2v-2z"/>
            </svg>
            '
            title="Component-Driven Page Crafting"
            description="Leverage our curated collection of Blade components to swiftly piece together professional-grade landing pages:"
            :features="[
                'Custom homemade components',
                'Jetstream components',
                'Rapidly build and customize pages',
                'Consistent design across your SaaS',
                'Customize your landing page with your own theme'
            ]"
        >
        </x-interactive-feature-tab>

        <x-interactive-feature-tab
            tabId="themes"
            name="Themes"
            mediaType="image"
            mediaUrl="{{ asset('illustrations/themes.png') }}"
            icon='
            <svg xmlns="http://www.w3.org/2000/svg" class="w-8 h-8 mb-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21a4 4 0 01-4-4V5a2 2 0 012-2h4a2 2 0 012 2v12a4 4 0 01-4 4zm0 0h12a2 2 0 002-2v-4a2 2 0 00-2-2h-2.343M11 7.343l1.657-1.657a2 2 0 012.828 0l2.829 2.829a2 2 0 010 2.828l-8.486 8.485M7 17h.01"/>
            </svg>
            '
            title="Versatile Theme System"
            description="Choose from our carefully crafted themes or create your own to match your brand identity:"
            :features="[
                'Four built-in themes (Light, Dark, Sunset, Nature)',
                'Easy theme switching with APP_THEME environment variable',
                'Consistent styling across all components',
                'Fully customizable color schemes',
                'Responsive design across all themes'
            ]"
        >
        </x-interactive-feature-tab>

        <x-interactive-feature-tab
            tabId="localization"
            name="Localization"
            mediaType="image"
            mediaUrl="{{ asset('illustrations/jsonfr.png') }}"
            icon='
            <svg xmlns="http://www.w3.org/2000/svg" class="w-8 h-8 mb-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5h12M9 3v2m1.048 9.5A18.022 18.022 0 016.412 9m6.088 9h7M11 21l5-10 5 10M12.751 5C11.783 10.77 8.07 15.61 3 18.129"/>
            </svg>
            '
            title="Built-in Localization"
            description="Reach a global audience with out-of-the-box localization support:"
            :features="[
                'Support for multiple languages (English, French, Spanish, Italian,<br> German, Russian, Turkish, Arabic, Chinese, Japanese, Korean and more...)',
                'Easy translation management',
                'Localized user interfaces',
                'Expand your reach to international markets'
            ]"
        >
        </x-interactive-feature-tab>
    </x-interactive-features-section>

    <x-cta-button class="text-white bg-lime-600 hover:bg-lime-700 !my-0" text="Learn more" alpine="https://saashovel.com" />

    {{-- <div x-data="{ showSections: false }">
        <x-toggle-button
            clickInView="true"
            x:is-showing="showSections"
            @toggle-sections.window="showSections = $event.detail"
        />

        <x-features-section x:show-sections="showSections">
            <x-feature
                id="localization"
                title="Go Global from Day One"
                description="With built-in localization support, your SaaS is ready for an international audience right from the start. Expand your reach and increase your market potential effortlessly."
                media-type="image"
                media-src="illustrations/jsonfr.png"
                media-position="right"
            >
                <li>Easy translation management</li>
                <li>Support for multiple languages</li>
                <li>Localized user interfaces</li>
            </x-feature>
            <x-feature
                id="cms"
                title="Powerful Built-in CMS"
                description="Manage your content effortlessly with the integrated Content Management System. Create, edit, and organize your pages with ease."
                media-type="video"
                media-src="illustrations/cms.mp4"
                media-position="right"
            >
                <li>Intuitive page builder</li>
                <li>Custom page permissions</li>
                <li>SEO optimization tools</li>
                <li>Media library management</li>
                <li>Contact page</li>
            </x-feature>

            <x-feature
                id="admin-panel"
                title="Comprehensive Admin Panel"
                description="Take control of your SaaS with the feature-rich admin panel. Monitor performance, manage users, and make data-driven decisions."
                media-type="video"
                media-src="illustrations/admin.mp4"
                media-position="left"
            >
                <li>Google Analytics integration</li>
                <li>User management</li>
                <li>.Env config to customize features</li>
                <li>Contact feature</li>
                <li>CMS features</li>
                <li>Customizable dashboard</li>
            </x-feature>

            <x-feature
                id="auth-screens"
                title="Modern Authentication Screens"
                description="Provide a seamless onboarding experience with the sleek and secure authentication screens."
                media-type="video"
                media-src="illustrations/auth.mp4"
                media-position="right"
            >
                <li>Social login integration</li>
                <li>Two-factor authentication</li>
                <li>Email confirmation functionality</li>
                <li>Password reset functionality</li>
                <li>Customizable design</li>
            </x-feature>

            <x-feature
                id="permissions"
                title="Smooth permission handling"
                description="Effortlessly manage user access with the powerful and flexible permission system, seamlessly integrated with Laravel's authentication."
                media-type="image"
                media-src="illustrations/permissions.png"
                media-position="left"
            >
                <li><strong>@@can</strong> and <strong>@@cannot</strong> directives to restrict access to specific subscriber tiers or others</li>
                <li><strong>$user->can()</strong> and <strong>$user->cannot()</strong> methods to restrict access to specific subscriber tiers or others</li>
                <li>Route middlewares to restrict access to specific subscriber tiers or others</li>
            </x-feature>

            <x-feature
                id="components"
                title="Component-Driven Page Crafting"
                description="Leverage our curated collection of Blade components to swiftly piece together professional-grade landing pages, saving valuable development time."
                media-type="image"
                media-src="illustrations/component.png"
                media-position="right"
            >
                <li>Custom homemade components</li>
                <li><a class="font-bold" href="https://jetstream.laravel.com" target="_blank" rel="noopener noreferrer">Jetstream</a> components</li>
            </x-feature>
        </x-features-section>
    </div> --}}

    @cannot('access premium features')
        @cannot('access basic features')
            @if ($billingProvider === 'stripe')
                @include('livewire.pages.landing-page.partials.stripe-price-table')
            @endif
        @endcannot
    @endcannot

    <x-faq-section>
        <x-faq-item>
            <x-slot name="question">
                What do I get with SaaShovel?
            </x-slot>
            <x-slot name="answer">
                With SaaShovel, you get: <br>
                &nbsp;&nbsp;• A starter-kit for running a SaaS business, including payment systems, database integration, authentication, CMS, permission access, UI components, and more. <br>
                &nbsp;&nbsp;• PHP Artisan commands to automate development and production processes <br>
                &nbsp;&nbsp;• Comprehensive documentation to help you set up your app and customize it to fit your needs <br>
            </x-slot>
        </x-faq-item>
        <x-faq-item>
            <x-slot name="question">
                What technologies does SaaShovel use?
            </x-slot>
            <x-slot name="answer">
                SaaShovel is powered by the TALL stack, which includes Tailwind, Alpine.js, Laravel, and Livewire. It also uses Jetstream for user account management and Filament for the admin panel. You can leverage the power of all those tools to build a comprehensive SaaS.
            </x-slot>
        </x-faq-item>

        {{-- <x-faq-item>
            <x-slot name="question">
                My tech stack is different, can I still use SaaShovel?
            </x-slot>
            <x-slot name="answer">
                SaaShovel is built on the TALL stack (Tailwind, Alpine.js, Laravel, Livewire). If you're comfortable with these technologies, you can use SaaShovel. Many libraries are independent, so you can swap out components like the email service or database as needed.
            </x-slot>
        </x-faq-item> --}}

        {{-- <x-faq-item>
            <x-slot name="question">
                Is SaaShovel just a website template?
            </x-slot>
            <x-slot name="answer">
                SaaShovel is more than just a template. It provides reusable sections for quick site building (like pricing, FAQ, blog), UI components (buttons, modals, popovers), and essential tools for running an online business (payment processing, emails, SEO, etc.).
            </x-slot>
        </x-faq-item> --}}

        <x-faq-item>
            <x-slot name="question">
                How often is SaaShovel updated?
            </x-slot>
            <x-slot name="answer">
                SaaShovel is regularly updated to ensure it remains current and effective. The exact frequency may vary, but you can expect consistent improvements and additions.
            </x-slot>
        </x-faq-item>

        {{-- <x-faq-item>
            <x-slot name="question">
                Are there any other costs associated with using SaaShovel?
            </x-slot>
            <x-slot name="answer">
                The costs associated with SaaShovel depend on your hosting choices and the services you integrate. Many hosting platforms offer free tiers, allowing you to launch your first app with minimal costs. Additional services may have their own pricing structures.
            </x-slot>
        </x-faq-item> --}}

        <x-faq-item>
            <x-slot name="question">
                Can I get a refund?
            </x-slot>
            <x-slot name="answer">
                Once you've gained access to the SaaShovel repository, refunds are not available as you have permanent access to the product. Please make sure to read the <a class="text-lime-600" href="https://saashovel.com/documentation#Components">documentation</a> before making your purchase decision.
            </x-slot>
        </x-faq-item>

        {{-- <x-faq-item>
            <x-slot name="question">
                How does SaaShovel handle the subscription process?
            </x-slot>
            <x-slot name="answer">
                SaaShovel provides an effortless subscription journey with one-click plan selection, streamlined user registration, secure payment processing, automatic redirection to dashboard, real-time subscription status updates, and webhook integration for payment confirmation.
            </x-slot>
        </x-faq-item> --}}
    </x-faq-section>

    {{-- <x-testimonial-section
        section-title="What Our Customers Say"
        :testimonials="[
            [
                'quote' => 'Amazing product that simplified our workflow.',
                'name' => 'John Doe',
                'title' => 'CEO at Company',
                'avatar' => asset('illustrations/john.png')
            ],
            [
                'quote' => 'Best solution we\'ve found in the market.',
                'name' => 'Jane Smith',
                'title' => 'Product Manager',
                'avatar' => asset('illustrations/jane.png')
            ],
            [
                'quote' => 'Best solution we\'ve found in the market.',
                'name' => 'Jane Smith',
                'title' => 'Product Manager',
                'avatar' => asset('illustrations/jane.png')
            ],
        ]"
    /> --}}

    <x-cta-section
        title="Ready to Launch Your SaaS?"
        description="Our innovative starter-kit is here to turn your SaaS concept into a launchable product. Reduce development time, optimize your budget and channel your efforts into building something extraordinary!"
        ctaText="Get Started Today"
        ctaUrl="#pricing"
    >
        <x-slot name="image">
            <p class="text-center mb-10 lg:mb-0 text-[8rem] sm:text-[10rem] md:text-[12rem] lg:text-[14rem] xl:text-[16rem] leading-none">🚀</p>
        </x-slot>
    </x-cta-section>
</div>
